/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.JdmServer;
import ibm.nways.jdm.Log;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.RemoteModelFactoryManager;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.RemoteWatchableImpl;
import ibm.nways.jdm.Service;
import ibm.nways.jdm.ServiceManager;
import ibm.nways.jdm.Tool;
import ibm.nways.jdm.Toolbar;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class JdmServerImpl
extends RemoteWatchableImpl
implements JdmServer {
    private boolean isReady = false;
    private static Registry registry;
    private static int port;
    private Properties properties;
    private ServiceManager services;
    private Vector tools;
    private Toolbar toolbar;
    private boolean hasValidLicense = true;
    private String licenseMsg;
    private static int remoteTcpPort;
    private static int DefaultRemoteTcpPort;
    public static final String TcpPortProperty = "RemoteTcpPort";
    private static JdmServerImpl singleton;
    public static final String DefaultPropertyFilename = "JdmServerProperties.txt";
    public static final String PropertyNameForPropertyFile = "PropertyFile";
    public static final String PortProperty = "ibm.nways.jdm.serverport";
    public static final String TrapPortProperty = "trapPortNumber";
    public static final String ServicesProperty = "services";
    public static final String ToolsProperty = "tools";
    public static final String LogFileProperty = "logFile";
    public static final String LoggingStateProperty = "startLogging";
    public static final String LoggingOnValue = "yes";
    public static final String JdmServerRegisteredName = "JdmServer";
    public static final String ValidLicenseSysPropName = "validLicense";
    private static Vector models;

    protected JdmServerImpl() throws RemoteException {
        singleton = this;
    }

    public static Registry getRegistry() {
        return registry;
    }

    public boolean isReady() throws RemoteException {
        return this.isReady;
    }

    public void init() {
        String string;
        String string2 = System.getProperty(ValidLicenseSysPropName);
        if (string2 != null && string2.equals("false")) {
            this.hasValidLicense = false;
        }
        if ((string = System.getProperty(PropertyNameForPropertyFile)) == null) {
            string = DefaultPropertyFilename;
        }
        this.properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.properties.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Cannot find " + string);
        }
        catch (IOException iOException) {
            System.out.println("Error reading properties file: " + iOException.getMessage());
        }
        this.initLogging();
        this.initTools();
        this.createToolbar();
        this.initServices();
        this.services.start();
        this.isReady = true;
    }

    public void shutdown() {
        try {
            System.out.println("**** STARTING JDM SERVER SHUTDOWN ****");
            this.services.shutdown();
            registry.unbind(JdmServerRegisteredName);
            System.out.println("**** JDM SERVER SHUTDOWN COMPLETE ****");
        }
        catch (Exception exception) {
            System.out.println("Exception while shutting down.");
            exception.printStackTrace();
        }
        System.exit(0);
    }

    public int getPort() {
        return port;
    }

    public int getRemoteTcpPort() {
        return remoteTcpPort;
    }

    public String getVersion() throws RemoteException {
        return "2.00";
    }

    private void initServices() {
        this.services = new ServiceManager();
        String string = JdmServerImpl.getProperty(ServicesProperty);
        if (string != null) {
            this.services.registerClasses(string);
        }
    }

    public static JdmServerImpl getSingleton() {
        return singleton;
    }

    public Service getService(Object object) {
        return this.services.get(object);
    }

    public static String getProperty(String string) {
        String string2 = null;
        if (JdmServerImpl.singleton.properties != null) {
            string2 = JdmServerImpl.singleton.properties.getProperty(string);
        }
        return string2;
    }

    public boolean hasValidLicense() throws RemoteException {
        return this.hasValidLicense;
    }

    public RemoteModel getModelFor(String string, String string2, RemoteStatus remoteStatus) throws RemoteException {
        if (!this.hasValidLicense) {
            return null;
        }
        RemoteModel remoteModel = null;
        RemoteModelFactoryManager remoteModelFactoryManager = (RemoteModelFactoryManager)this.services.get((Object)"remoteModels");
        if (remoteModelFactoryManager != null && (remoteModel = remoteModelFactoryManager.getModelFor((Object)string2, (Object)string, remoteStatus)) != null && !models.contains(remoteModel)) {
            models.addElement(remoteModel);
            this.setChanged();
            this.notifyWatchers(remoteModel);
        }
        return remoteModel;
    }

    public Vector getInUseModels() throws RemoteException {
        return models;
    }

    public void removeModel(RemoteModel remoteModel) {
        models.removeElement(remoteModel);
    }

    private void initTools() {
        this.tools = new Vector();
        String string = JdmServerImpl.getProperty(ToolsProperty);
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                Class<?> clazz = Class.forName(string2);
                Tool tool = (Tool)clazz.newInstance();
                this.tools.addElement(tool);
            }
            catch (Exception exception) {
                System.out.println("Error creating tool \"" + string2 + "\"");
                exception.printStackTrace();
            }
        }
    }

    private void createToolbar() {
        if (this.tools.size() > 0) {
            this.toolbar = new Toolbar(this.tools);
        }
    }

    private void initLogging() {
        boolean bl = false;
        String string = JdmServerImpl.getProperty(LoggingStateProperty);
        if (string != null && string.equals(LoggingOnValue)) {
            bl = true;
        }
        Log.getLog().setLoggingState(bl);
        String string2 = JdmServerImpl.getProperty(LogFileProperty);
        if (string2 == null) {
            return;
        }
        Log.getLog().setFilename(string2);
    }

    public void setLicenseMsg(String string) {
        this.licenseMsg = string;
    }

    public String getLicenseMsg() throws RemoteException {
        return this.licenseMsg;
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty(TcpPortProperty);
        remoteTcpPort = string != null ? Integer.parseInt(string) : DefaultRemoteTcpPort;
        String string2 = System.getProperty(PortProperty);
        System.setSecurityManager(new RMISecurityManager());
        try {
            port = string2 != null ? Integer.parseInt(string2) : 2099;
            try {
                registry = LocateRegistry.createRegistry(port);
                JdmServerImpl jdmServerImpl = new JdmServerImpl();
                registry.rebind(JdmServerRegisteredName, jdmServerImpl);
                jdmServerImpl.init();
                System.out.println("-*-*-*-*-*-*-*-*-* Jdm server initialized on port " + jdmServerImpl.getPort() + "-*-*-*-*-*-*-*-*-*");
                return;
            }
            catch (Exception exception) {
                System.out.println("Error initializing Jdm Server");
                exception.printStackTrace();
                System.exit(1);
                return;
            }
        }
        catch (Exception exception) {
            System.out.print("JdmServerImpl.main: an exception occurred:");
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    static {
        DefaultRemoteTcpPort = 2080;
        models = new Vector();
    }
}

